/*
 * Created on Sep 10, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package Validators;
import JavaBeans.*;

/**
 * @author student
 *
 * This class is being used for validating coffee preference data.
 * 
 */
public class CoffeePreferenceValidator {
	private String message;

	/**
	 * This method is being used for getting an error message if the validation
	 * was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the validation
	 * is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	
	/**
	 * This method is being used for validating a given coffee preference
	 * data.
	 * @param coffeeData The coffee details to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(CoffeePreference_Data coffeeData) {

		CoffeePreference_Data coffeedata = coffeeData;
		
		String quantity;
		String itemcode;
		String description;

		itemcode = coffeedata.getItemCode();
		quantity = coffeedata.getQuantity();
		description = coffeedata.getDescription();

		System.out.println("coffee quantity : " + quantity);
		System.out.println("coffee itemCode : " + itemcode);

		//check quantity.
		if (quantity == null) {
			message = "Quantity field is empty.";
			return false;
		}

		if (!quantity.matches("^[0-9]+$")) {
			message = " Quantity must be a digit between 1 and 9 inclusive.";
			return false;
		}
		return true;

	}

}
